(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76536,       1516]
NotebookOptionsPosition[     73142,       1417]
NotebookOutlinePosition[     74744,       1469]
CellTagsIndexPosition[     74701,       1466]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[StyleBox["Rules for integrands involving Bessel \
functions",
  FontFamily->"Arial"]], "None"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.4965234353062396`*^9, {3.5193214825316973`*^9, 3.5193214852617016`*^9}, {
   3.523316399894187*^9, 3.5233164032341914`*^9}, {3.523318350558202*^9, 
   3.5233183516382036`*^9}, {3.536542725780803*^9, 3.536542725780803*^9}, {
   3.5367764878952584`*^9, 3.5367764886452594`*^9}, {3.544322815209103*^9, 
   3.5443228192963104`*^9}, {3.5450662624913826`*^9, 3.545066292141424*^9}, {
   3.545066402271579*^9, 3.5450664054415827`*^9}, {3.5450834884295015`*^9, 
   3.5450834895895033`*^9}, {3.5454961263762493`*^9, 
   3.5454961321462574`*^9}, {3.5454963863166127`*^9, 
   3.5454964580867133`*^9}, {3.545497046127537*^9, 3.545497046127537*^9}, {
   3.5454971130676303`*^9, 3.545497136257663*^9}, 3.545610399977621*^9, {
   3.546040778592962*^9, 3.546040778592962*^9}, {3.5461052065706367`*^9, 
   3.5461052249474688`*^9}, {3.546191339879622*^9, 3.5461913430596266`*^9}, {
   3.5462141824067917`*^9, 3.5462142145768366`*^9}, {3.5462145455473003`*^9, 
   3.5462145601073203`*^9}, {3.5463149785974817`*^9, 
   3.5463149794195285`*^9}, {3.5488738437683954`*^9, 
   3.5488738699084315`*^9}, {3.5488890647645535`*^9, 3.548889080804576*^9}, {
   3.5505951583099127`*^9, 3.5505951620351257`*^9}, {3.5758457803910656`*^9, 
   3.5758457938510847`*^9}, {3.5758458780912023`*^9, 
   3.5758458797312045`*^9}, {3.5758460250714083`*^9, 3.575846028691413*^9}, {
   3.5758461031815176`*^9, 3.575846103681518*^9}, {3.5758463018517957`*^9, 
   3.5758463042917986`*^9}, {3.5758464155019546`*^9, 3.575846417191957*^9}, {
   3.5758468610025787`*^9, 3.5758468696025906`*^9}, {3.5758469815427475`*^9, 
   3.5758469940427647`*^9}, {3.575847092102902*^9, 3.575847093372904*^9}, {
   3.5758472070230627`*^9, 3.5758472111630683`*^9}, {3.721095566465252*^9, 
   3.721095567548314*^9}},
 TextAlignment->Center,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["1.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, 3.7210957216461277`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, 3.7210957216461277`*^9, 3.7210960392932963`*^9, {
   3.721096252056466*^9, 3.7210962522594776`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["1.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[BoxData[
      RowBox[{
       FractionBox[
        RowBox[{"n", "+", "1"}], "2"], "\[Element]", 
       SuperscriptBox["\[DoubleStruckCapitalZ]", "+"]}]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, 3.7210957216461277`*^9, 3.7210960392932963`*^9, {
   3.7210961977763615`*^9, 3.721096204785762*^9}, {3.7210962443600254`*^9, 
   3.7210962655372367`*^9}, {3.721097168472882*^9, 3.7210971684738817`*^9}, 
   3.721099380786419*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["1:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"1", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193422443984776`*^9, 3.5193422447260776`*^9}, 
   3.5193424488212357`*^9, {3.5193434708254333`*^9, 3.519343473103037*^9}, {
   3.5193435097631016`*^9, 3.51934353169674*^9}, {3.519345739319023*^9, 
   3.519345739599823*^9}, 3.5193462601259375`*^9, {3.5193475061060295`*^9, 
   3.5193475233908596`*^9}, {3.519351391880224*^9, 3.5193513931402254`*^9}, {
   3.519403773021052*^9, 3.5194037798564425`*^9}, 3.5194106793250647`*^9, {
   3.519537578341393*^9, 3.5195375792305946`*^9}, {3.5195376277778797`*^9, 
   3.51953767927357*^9}, {3.5197586260636144`*^9, 3.5197586260636144`*^9}, {
   3.51978053295651*^9, 3.519780542862528*^9}, {3.5197806526087203`*^9, 
   3.5197806657595434`*^9}, {3.5197807490168896`*^9, 3.5197807642581167`*^9}, 
   3.5197809004619555`*^9, {3.519782653514635*^9, 3.5197826623286505`*^9}, {
   3.5200207810164795`*^9, 3.520020785046485*^9}, {3.5213126833374643`*^9, 
   3.5213126833374643`*^9}, {3.521328235411002*^9, 3.521328235411002*^9}, {
   3.523315567893022*^9, 3.523315567893022*^9}, {3.5233157569332867`*^9, 
   3.5233157613032923`*^9}, {3.5323023198133526`*^9, 3.532302355723403*^9}, {
   3.5323026417638035`*^9, 3.5323026417638035`*^9}, {3.5323026980138817`*^9, 
   3.5323026980138817`*^9}, {3.532636287104328*^9, 3.532636287104328*^9}, {
   3.5330803686035347`*^9, 3.533080368863535*^9}, {3.533248909289961*^9, 
   3.5332489110299635`*^9}, {3.534962469565694*^9, 3.5349624910757236`*^9}, {
   3.5349625224057674`*^9, 3.534962522655768*^9}, {3.534965265519608*^9, 
   3.534965265519608*^9}, {3.5349668288168063`*^9, 3.5349668292668066`*^9}, {
   3.5349747358481646`*^9, 3.5349747358481646`*^9}, {3.534975457949176*^9, 
   3.534975457949176*^9}, {3.5368633963532934`*^9, 3.536863396571694*^9}, {
   3.541644322511304*^9, 3.5416443577513533`*^9}, {3.5416458269234104`*^9, 
   3.541645839633428*^9}, {3.5416460312236967`*^9, 3.541646031483697*^9}, 
   3.541646227783972*^9, {3.541647080335165*^9, 3.5416471077052035`*^9}, {
   3.541648997607849*^9, 3.5416489978278494`*^9}, 3.541649088407976*^9, {
   3.5417848711596775`*^9, 3.541784902429721*^9}, {3.541786145331461*^9, 
   3.5417861455914617`*^9}, {3.5417870037166634`*^9, 3.5417870039366636`*^9}, 
   3.5462979620242105`*^9, {3.546298264094633*^9, 3.546298265344635*^9}, {
   3.546299000235664*^9, 3.546299001505666*^9}, {3.546315119909564*^9, 
   3.5463151267659564`*^9}, {3.547227356319705*^9, 3.547227356319705*^9}, 
   3.547918559331044*^9, {3.547918610170952*^9, 3.5479186304411116`*^9}, 
   3.548537755517557*^9, 3.5485441629685287`*^9, 3.5485517520154133`*^9, {
   3.5488740727887154`*^9, 3.5488740727887154`*^9}, {3.548874206618903*^9, 
   3.548874206808903*^9}, 3.548877100795455*^9, 3.5525328819892797`*^9, 
   3.5527731546608505`*^9, 3.553222366079949*^9, {3.574878892237171*^9, 
   3.574878896043578*^9}, {3.5748794303045163`*^9, 3.57487944361134*^9}, 
   3.574881171829175*^9, {3.574887120235253*^9, 3.574887131005268*^9}, 
   3.5748877279261036`*^9, {3.574888405747052*^9, 3.574888405747052*^9}, {
   3.574959730430708*^9, 3.574959734700714*^9}, {3.5749599651210365`*^9, 
   3.57495996777104*^9}, {3.574961504633192*^9, 3.574961504973192*^9}, 
   3.57496462482756*^9, 3.721095723128213*^9, {3.721096023659402*^9, 
   3.721096043414532*^9}, {3.7210960938844185`*^9, 3.721096232980375*^9}, 
   3.721096268636414*^9, {3.7210972245170875`*^9, 3.72109724029699*^9}, 
   3.72109938412661*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210971402062654`*^9, 3.721097149362789*^9}, 3.721097286347624*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"1", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"BesselJ", "[", 
        RowBox[{"0", ",", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]}], "]"}], "b"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, {
   3.7210780475842295`*^9, 3.7210780582708406`*^9}, {3.7210781941136103`*^9, 
   3.7210782613824577`*^9}, 3.721078305663991*^9, {3.7210958547237396`*^9, 
   3.7210958626391926`*^9}, 3.7210965808152695`*^9, 3.7210972916149254`*^9, 
   3.721097338821625*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"0", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.72109588323137*^9, {3.721095939300577*^9, 3.721095947595052*^9}, {
   3.721097028606882*^9, 3.721097050886156*^9}, {3.721097356788653*^9, 
   3.7210973885654707`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[BoxData[
      RowBox[{
       FractionBox[
        RowBox[{"n", "-", "1"}], "2"], "\[Element]", 
       SuperscriptBox["\[DoubleStruckCapitalZ]", "+"]}]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193422443984776`*^9, 3.5193422447260776`*^9}, 
   3.5193424488212357`*^9, {3.5193434708254333`*^9, 3.519343473103037*^9}, {
   3.5193435097631016`*^9, 3.51934353169674*^9}, {3.519345739319023*^9, 
   3.519345739599823*^9}, 3.5193462601259375`*^9, {3.5193475061060295`*^9, 
   3.5193475233908596`*^9}, {3.519351391880224*^9, 3.5193513931402254`*^9}, {
   3.519403773021052*^9, 3.5194037798564425`*^9}, 3.5194106793250647`*^9, {
   3.519537578341393*^9, 3.5195375792305946`*^9}, {3.5195376277778797`*^9, 
   3.51953767927357*^9}, {3.5197586260636144`*^9, 3.5197586260636144`*^9}, {
   3.51978053295651*^9, 3.519780542862528*^9}, {3.5197806526087203`*^9, 
   3.5197806657595434`*^9}, {3.5197807490168896`*^9, 3.5197807642581167`*^9}, 
   3.5197809004619555`*^9, {3.519782653514635*^9, 3.5197826623286505`*^9}, {
   3.5200207810164795`*^9, 3.520020785046485*^9}, {3.5213126833374643`*^9, 
   3.5213126833374643`*^9}, {3.521328235411002*^9, 3.521328235411002*^9}, {
   3.523315567893022*^9, 3.523315567893022*^9}, {3.5233157569332867`*^9, 
   3.5233157613032923`*^9}, {3.5323023198133526`*^9, 3.532302355723403*^9}, {
   3.5323026417638035`*^9, 3.5323026417638035`*^9}, {3.5323026980138817`*^9, 
   3.5323026980138817`*^9}, {3.532636287104328*^9, 3.532636287104328*^9}, {
   3.5330803686035347`*^9, 3.533080368863535*^9}, {3.533248909289961*^9, 
   3.5332489110299635`*^9}, {3.534962469565694*^9, 3.5349624910757236`*^9}, {
   3.5349625224057674`*^9, 3.534962522655768*^9}, {3.534965265519608*^9, 
   3.534965265519608*^9}, {3.5349668288168063`*^9, 3.5349668292668066`*^9}, {
   3.5349747358481646`*^9, 3.5349747358481646`*^9}, {3.534975457949176*^9, 
   3.534975457949176*^9}, {3.5368633963532934`*^9, 3.536863396571694*^9}, {
   3.541644322511304*^9, 3.5416443577513533`*^9}, {3.5416458269234104`*^9, 
   3.541645839633428*^9}, {3.5416460312236967`*^9, 3.541646031483697*^9}, 
   3.541646227783972*^9, {3.541647080335165*^9, 3.5416471077052035`*^9}, {
   3.541648997607849*^9, 3.5416489978278494`*^9}, 3.541649088407976*^9, {
   3.5417848711596775`*^9, 3.541784902429721*^9}, {3.541786145331461*^9, 
   3.5417861455914617`*^9}, {3.5417870037166634`*^9, 3.5417870039366636`*^9}, 
   3.5462979620242105`*^9, {3.546298264094633*^9, 3.546298265344635*^9}, {
   3.546299000235664*^9, 3.546299001505666*^9}, {3.546315119909564*^9, 
   3.5463151267659564`*^9}, {3.547227356319705*^9, 3.547227356319705*^9}, 
   3.547918559331044*^9, {3.547918610170952*^9, 3.5479186304411116`*^9}, 
   3.548537755517557*^9, 3.5485441629685287`*^9, 3.5485517520154133`*^9, {
   3.5488740727887154`*^9, 3.5488740727887154`*^9}, {3.548874206618903*^9, 
   3.548874206808903*^9}, 3.548877100795455*^9, 3.5525328819892797`*^9, 
   3.5527731546608505`*^9, 3.553222366079949*^9, {3.574878892237171*^9, 
   3.574878896043578*^9}, {3.5748794303045163`*^9, 3.57487944361134*^9}, 
   3.574881171829175*^9, {3.574887120235253*^9, 3.574887131005268*^9}, 
   3.5748877279261036`*^9, {3.574888405747052*^9, 3.574888405747052*^9}, {
   3.574959730430708*^9, 3.574959734700714*^9}, {3.5749599651210365`*^9, 
   3.57495996777104*^9}, {3.574961504633192*^9, 3.574961504973192*^9}, 
   3.57496462482756*^9, 3.721095723128213*^9, {3.721096023659402*^9, 
   3.721096043414532*^9}, {3.7210960938844185`*^9, 3.721096232980375*^9}, 
   3.721096268636414*^9, {3.7210972245170875`*^9, 3.7210972247431*^9}, 
   3.7210993850856647`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"BesselJ", "[", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]}], "]"}]}]}], "b"]}], "+", 
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"n", "-", "2"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]],
  CellChangeTimes->{{3.7210968097653646`*^9, 3.7210968266993337`*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210966186254325`*^9, 3.721096619531484*^9}, {3.721096840585128*^9, 
   3.7210968414551773`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"n", "-", "1"}], "2"], "\[Element]", 
   SuperscriptBox["\[DoubleStruckCapitalZ]", "+"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210971402062654`*^9, 3.721097149362789*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"BesselJ", "[", 
          RowBox[{
           RowBox[{"n", "-", "1"}], ",", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}]}], "]"}]}], "b"]}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"n", "-", "2"}], ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, {
   3.7210780475842295`*^9, 3.7210780582708406`*^9}, {3.7210781941136103`*^9, 
   3.7210782613824577`*^9}, 3.721078305663991*^9, {3.7210958547237396`*^9, 
   3.7210958626391926`*^9}, 3.7210965808152695`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}], "/", "b"}]}], " ", "+", " ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{
        RowBox[{"n", "-", "2"}], ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}], ",", "x"}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IGtQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ",", "0"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.72109588323137*^9, {3.721095939300577*^9, 3.721095947595052*^9}, {
   3.721097028606882*^9, 3.721097050886156*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["x:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}], "  ", 
     StyleBox["when",
      FontFamily->"Arial",
      FontWeight->"Plain"], 
     StyleBox["  ",
      FontFamily->"Arial",
      FontWeight->"Plain"], Cell[BoxData[
      RowBox[{"n", "\[Element]", 
       SuperscriptBox["\[DoubleStruckCapitalZ]", "-"]}]], 
      "None"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193422443984776`*^9, 3.5193422447260776`*^9}, 
   3.5193424488212357`*^9, {3.5193434708254333`*^9, 3.519343473103037*^9}, {
   3.5193435097631016`*^9, 3.51934353169674*^9}, {3.519345739319023*^9, 
   3.519345739599823*^9}, 3.5193462601259375`*^9, {3.5193475061060295`*^9, 
   3.5193475233908596`*^9}, {3.519351391880224*^9, 3.5193513931402254`*^9}, {
   3.519403773021052*^9, 3.5194037798564425`*^9}, 3.5194106793250647`*^9, {
   3.519537578341393*^9, 3.5195375792305946`*^9}, {3.5195376277778797`*^9, 
   3.51953767927357*^9}, {3.5197586260636144`*^9, 3.5197586260636144`*^9}, {
   3.51978053295651*^9, 3.519780542862528*^9}, {3.5197806526087203`*^9, 
   3.5197806657595434`*^9}, {3.5197807490168896`*^9, 3.5197807642581167`*^9}, 
   3.5197809004619555`*^9, {3.519782653514635*^9, 3.5197826623286505`*^9}, {
   3.5200207810164795`*^9, 3.520020785046485*^9}, {3.5213126833374643`*^9, 
   3.5213126833374643`*^9}, {3.521328235411002*^9, 3.521328235411002*^9}, {
   3.523315567893022*^9, 3.523315567893022*^9}, {3.5233157569332867`*^9, 
   3.5233157613032923`*^9}, {3.5323023198133526`*^9, 3.532302355723403*^9}, {
   3.5323026417638035`*^9, 3.5323026417638035`*^9}, {3.5323026980138817`*^9, 
   3.5323026980138817`*^9}, {3.532636287104328*^9, 3.532636287104328*^9}, {
   3.5330803686035347`*^9, 3.533080368863535*^9}, {3.533248909289961*^9, 
   3.5332489110299635`*^9}, {3.534962469565694*^9, 3.5349624910757236`*^9}, {
   3.5349625224057674`*^9, 3.534962522655768*^9}, {3.534965265519608*^9, 
   3.534965265519608*^9}, {3.5349668288168063`*^9, 3.5349668292668066`*^9}, {
   3.5349747358481646`*^9, 3.5349747358481646`*^9}, {3.534975457949176*^9, 
   3.534975457949176*^9}, {3.5368633963532934`*^9, 3.536863396571694*^9}, {
   3.541644322511304*^9, 3.5416443577513533`*^9}, {3.5416458269234104`*^9, 
   3.541645839633428*^9}, {3.5416460312236967`*^9, 3.541646031483697*^9}, 
   3.541646227783972*^9, {3.541647080335165*^9, 3.5416471077052035`*^9}, {
   3.541648997607849*^9, 3.5416489978278494`*^9}, 3.541649088407976*^9, {
   3.5417848711596775`*^9, 3.541784902429721*^9}, {3.541786145331461*^9, 
   3.5417861455914617`*^9}, {3.5417870037166634`*^9, 3.5417870039366636`*^9}, 
   3.5462979620242105`*^9, {3.546298264094633*^9, 3.546298265344635*^9}, {
   3.546299000235664*^9, 3.546299001505666*^9}, {3.546315119909564*^9, 
   3.5463151267659564`*^9}, {3.547227356319705*^9, 3.547227356319705*^9}, 
   3.547918559331044*^9, {3.547918610170952*^9, 3.5479186304411116`*^9}, 
   3.548537755517557*^9, 3.5485441629685287`*^9, 3.5485517520154133`*^9, {
   3.5488740727887154`*^9, 3.5488740727887154`*^9}, {3.548874206618903*^9, 
   3.548874206808903*^9}, 3.548877100795455*^9, 3.5525328819892797`*^9, 
   3.5527731546608505`*^9, 3.553222366079949*^9, {3.574878892237171*^9, 
   3.574878896043578*^9}, {3.5748794303045163`*^9, 3.57487944361134*^9}, 
   3.574881171829175*^9, {3.574887120235253*^9, 3.574887131005268*^9}, 
   3.5748877279261036`*^9, {3.574888405747052*^9, 3.574888405747052*^9}, {
   3.574959730430708*^9, 3.574959734700714*^9}, {3.5749599651210365`*^9, 
   3.57495996777104*^9}, {3.574961504633192*^9, 3.574961504973192*^9}, 
   3.57496462482756*^9, 3.721095723128213*^9, {3.721096023659402*^9, 
   3.721096043414532*^9}, {3.7210960938844185`*^9, 3.721096232980375*^9}, 
   3.721096268636414*^9, {3.7210972245170875`*^9, 3.7210972247431*^9}, {
   3.721097427908721*^9, 3.7210974432926006`*^9}, {3.7210992677549543`*^9, 
   3.7210992677549543`*^9}, {3.721099356480029*^9, 3.721099363552433*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["\<\
Derivation: Algebraic simplification\
\>", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210966186254325`*^9, 3.721096619531484*^9}, {3.721096840585128*^9, 
   3.7210968414551773`*^9}, {3.7210975677617197`*^9, 
   3.7210975677617197`*^9}, {3.7210986217010016`*^9, 3.721098638086939*^9}}],

Cell[TextData[{
 "Basis:",
 " If ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"n", ",", "z"}], "]"}], "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"], 
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"-", "n"}], ",", "z"}], "]"}]}]}]],
  CellChangeTimes->{{3.7210968097653646`*^9, 3.7210968266993337`*^9}}]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210966186254325`*^9, 3.721096619531484*^9}, {3.721096840585128*^9, 
   3.7210968414551773`*^9}, {3.7210975677617197`*^9, 
   3.7210975677617197`*^9}, {3.721098652158744*^9, 3.72109865926315*^9}, {
   3.7210987087649813`*^9, 3.7210987393497305`*^9}}],

Cell[TextData[{
 "Note: This rule not necessary since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically simplifies ",
 Cell[BoxData[
  RowBox[{"BesselJ", "[", 
   RowBox[{"n", ",", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]}], "]"}]],
  CellChangeTimes->{{3.7210968097653646`*^9, 3.7210968266993337`*^9}}],
 " to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "n"], 
   RowBox[{"BesselJ", "[", 
    RowBox[{
     RowBox[{"-", "n"}], ",", "z"}], "]"}]}]],
  CellChangeTimes->{{3.7210968097653646`*^9, 3.7210968266993337`*^9}}],
 " if ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", 
   SuperscriptBox["\[DoubleStruckCapitalZ]", "-"]}]],
  CellChangeTimes->{{3.7210968097653646`*^9, 3.7210968266993337`*^9}}],
 "."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210966186254325`*^9, 3.721096619531484*^9}, {3.721096840585128*^9, 
   3.7210968414551773`*^9}, {3.7210975677617197`*^9, 
   3.7210975677617197`*^9}, {3.7210986217010016`*^9, 3.721098638086939*^9}, {
   3.721099161511877*^9, 3.7210992760084257`*^9}, {3.7210993378859653`*^9, 
   3.721099339351049*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", 
   SuperscriptBox["\[DoubleStruckCapitalZ]", "-"]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9, {
   3.7210971402062654`*^9, 3.721097149362789*^9}, {3.721097482163824*^9, 
   3.7210974828198614`*^9}, {3.7210992973206453`*^9, 3.7210992973206453`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{
       RowBox[{"-", "n"}], ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, {
   3.7210780475842295`*^9, 3.7210780582708406`*^9}, {3.7210781941136103`*^9, 
   3.7210782613824577`*^9}, 3.721078305663991*^9, {3.7210958547237396`*^9, 
   3.7210958626391926`*^9}, 3.7210965808152695`*^9, {3.7210975882938943`*^9, 
   3.721097595794323*^9}, {3.7210987722636137`*^9, 3.7210987833642483`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n_", ",", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", 
   ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{
         RowBox[{"-", "n"}], ",", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}]}], "]"}], ",", "x"}], "]"}]}], " ", "/;", 
    "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"ILtQ", "[", 
      RowBox[{"n", ",", "0"}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.72109588323137*^9, {3.721095939300577*^9, 3.721095947595052*^9}, {
   3.721097028606882*^9, 3.721097050886156*^9}, {3.7210975753771553`*^9, 
   3.721097575823181*^9}, {3.7210976074419894`*^9, 3.7210976170015364`*^9}, 
   3.721098831579006*^9, {3.7210993060861464`*^9, 3.7210993238001595`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\t\t", 
  RowBox[{Cell[TextData[StyleBox["2:",
    FontFamily->"Arial",
    FontColor->RGBColor[1, 0, 0]]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193422443984776`*^9, 3.5193422447260776`*^9}, 
   3.5193424488212357`*^9, {3.5193434708254333`*^9, 3.519343473103037*^9}, {
   3.5193435097631016`*^9, 3.51934353169674*^9}, {3.519345739319023*^9, 
   3.519345739599823*^9}, 3.5193462601259375`*^9, {3.5193475061060295`*^9, 
   3.5193475233908596`*^9}, {3.519351391880224*^9, 3.5193513931402254`*^9}, {
   3.519403773021052*^9, 3.5194037798564425`*^9}, 3.5194106793250647`*^9, {
   3.519537578341393*^9, 3.5195375792305946`*^9}, {3.5195376277778797`*^9, 
   3.51953767927357*^9}, {3.5197586260636144`*^9, 3.5197586260636144`*^9}, {
   3.51978053295651*^9, 3.519780542862528*^9}, {3.5197806526087203`*^9, 
   3.5197806657595434`*^9}, {3.5197807490168896`*^9, 3.5197807642581167`*^9}, 
   3.5197809004619555`*^9, {3.519782653514635*^9, 3.5197826623286505`*^9}, {
   3.5200207810164795`*^9, 3.520020785046485*^9}, {3.5213126833374643`*^9, 
   3.5213126833374643`*^9}, {3.521328235411002*^9, 3.521328235411002*^9}, {
   3.523315567893022*^9, 3.523315567893022*^9}, {3.5233157569332867`*^9, 
   3.5233157613032923`*^9}, {3.5323023198133526`*^9, 3.532302355723403*^9}, {
   3.5323026417638035`*^9, 3.5323026417638035`*^9}, {3.5323026980138817`*^9, 
   3.5323026980138817`*^9}, {3.532636287104328*^9, 3.532636287104328*^9}, {
   3.5330803686035347`*^9, 3.533080368863535*^9}, {3.533248909289961*^9, 
   3.5332489110299635`*^9}, {3.534962469565694*^9, 3.5349624910757236`*^9}, {
   3.5349625224057674`*^9, 3.534962522655768*^9}, {3.534965265519608*^9, 
   3.534965265519608*^9}, {3.5349668288168063`*^9, 3.5349668292668066`*^9}, {
   3.5349747358481646`*^9, 3.5349747358481646`*^9}, {3.534975457949176*^9, 
   3.534975457949176*^9}, {3.5368633963532934`*^9, 3.536863396571694*^9}, {
   3.541644322511304*^9, 3.5416443577513533`*^9}, {3.5416458269234104`*^9, 
   3.541645839633428*^9}, {3.5416460312236967`*^9, 3.541646031483697*^9}, 
   3.541646227783972*^9, {3.541647080335165*^9, 3.5416471077052035`*^9}, {
   3.541648997607849*^9, 3.5416489978278494`*^9}, 3.541649088407976*^9, {
   3.5417848711596775`*^9, 3.541784902429721*^9}, {3.541786145331461*^9, 
   3.5417861455914617`*^9}, {3.5417870037166634`*^9, 3.5417870039366636`*^9}, 
   3.5462979620242105`*^9, {3.546298264094633*^9, 3.546298265344635*^9}, {
   3.546299000235664*^9, 3.546299001505666*^9}, {3.546315119909564*^9, 
   3.5463151267659564`*^9}, {3.547227356319705*^9, 3.547227356319705*^9}, 
   3.547918559331044*^9, {3.547918610170952*^9, 3.5479186304411116`*^9}, 
   3.548537755517557*^9, 3.5485441629685287`*^9, 3.5485517520154133`*^9, {
   3.5488740727887154`*^9, 3.5488740727887154`*^9}, {3.548874206618903*^9, 
   3.548874206808903*^9}, 3.548877100795455*^9, 3.5525328819892797`*^9, 
   3.5527731546608505`*^9, 3.553222366079949*^9, {3.574878892237171*^9, 
   3.574878896043578*^9}, {3.5748794303045163`*^9, 3.57487944361134*^9}, 
   3.574881171829175*^9, {3.574887120235253*^9, 3.574887131005268*^9}, 
   3.5748877279261036`*^9, {3.574888405747052*^9, 3.574888405747052*^9}, {
   3.574959730430708*^9, 3.574959734700714*^9}, {3.5749599651210365`*^9, 
   3.57495996777104*^9}, {3.574961504633192*^9, 3.574961504973192*^9}, 
   3.57496462482756*^9, 3.721095723128213*^9, {3.721096023659402*^9, 
   3.721096043414532*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, 
   3.4941724084687696`*^9, 3.4941724567488375`*^9, 3.494439179913333*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"n", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], " ", 
       RowBox[{"HypergeometricPFQ", "[", 
        RowBox[{
         RowBox[{"{", 
          FractionBox[
           RowBox[{"n", "+", "1"}], "2"], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox[
            RowBox[{"n", "+", "3"}], "2"], ",", 
           RowBox[{"n", "+", "1"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "4"]}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]}], "]"}]}], 
      RowBox[{
       SuperscriptBox["2", "n"], "b", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"n", "+", "2"}], "]"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.49409966398218*^9, 
   3.494099664952181*^9}, {3.4940997156722527`*^9, 3.494099716112253*^9}, 
   3.4941724567488375`*^9, 3.4944391698033185`*^9, 3.4944392275633993`*^9, {
   3.7210780475842295`*^9, 3.7210780582708406`*^9}, {3.7210781941136103`*^9, 
   3.7210782613824577`*^9}, 3.721078305663991*^9, {3.7210958547237396`*^9, 
   3.7210958626391926`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, 3.4941724567488375`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"n_", ",", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "/", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "3"}], ")"}], "/", "2"}], ",", 
         RowBox[{"n", "+", "1"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "^", "n"}], "*", "b", "*", 
       RowBox[{"Gamma", "[", 
        RowBox[{"n", "+", "2"}], "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, {
   3.494099665582182*^9, 3.4940996672021847`*^9}, {3.4940997193022575`*^9, 
   3.494099719662258*^9}, 3.4941724567488375`*^9, 3.4944391618433075`*^9, 
   3.72109588323137*^9, {3.721095939300577*^9, 3.721095947595052*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9, 3.4941724567488375`*^9}]
}, Closed]]
}, Closed]],

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["2.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", " ", "x"}], ")"}], "m"], " ", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, {3.574964922777977*^9, 3.574964926547982*^9}, 
   3.574971287956888*^9, {3.574971361966992*^9, 3.574971373617008*^9}, 
   3.709308508646453*^9, {3.7210769791321173`*^9, 3.7210769801441755`*^9}, 
   3.7210959654250717`*^9},
 FontSize->12,
 FontWeight->"Bold"],

Cell[BoxData[
 RowBox[{"\t", 
  RowBox[{Cell[TextData[StyleBox["3.",
    FontFamily->"Arial"]], "None"], "  ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "m"], " ", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, {3.574964922777977*^9, 3.574964926547982*^9}, 
   3.574971287956888*^9, 3.709308513902753*^9, {3.7093101696196337`*^9, 
   3.7093101700636587`*^9}, {3.7210770302870436`*^9, 
   3.7210770305670595`*^9}, {3.7210959671291685`*^9, 3.7210959700093336`*^9}},
 FontSize->12,
 FontWeight->"Bold"]
}, Closed]],

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["2.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, {3.7210957216461277`*^9, 3.7210957361179557`*^9}, {
   3.721095985459217*^9, 3.7210959857452335`*^9}},
 FontSize->12,
 FontWeight->"Bold"],

Cell[BoxData[
 RowBox[{Cell[TextData[StyleBox["3.",
   FontFamily->"Arial"]], "None"], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{"u", " ", 
    RowBox[{"BesselY", "[", 
     RowBox[{"n", ",", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.519247079685614*^9, {3.5193208582062006`*^9, 3.5193208612170057`*^9}, 
   3.5193325694253187`*^9, {3.5193415004828687`*^9, 3.5193415113404875`*^9}, {
   3.5193513965602303`*^9, 3.519351397420232*^9}, {3.5194037839416766`*^9, 
   3.5194037847117205`*^9}, 3.52105258275843*^9, 3.5210531741726685`*^9, {
   3.521057461672199*^9, 3.5210574760242243`*^9}, {3.521059881564049*^9, 
   3.521059886088057*^9}, {3.5213902158895197`*^9, 3.521390217543123*^9}, {
   3.521390827878595*^9, 3.521390829376197*^9}, {3.5214688792561245`*^9, 
   3.521468879443325*^9}, {3.523320201951167*^9, 3.523320202247567*^9}, {
   3.5288596764894824`*^9, 3.5288596768094826`*^9}, {3.529196266260353*^9, 
   3.5291962665099535`*^9}, {3.5291997050223927`*^9, 
   3.5291997052563934`*^9}, {3.529201346457276*^9, 3.529201347252877*^9}, {
   3.529285041073242*^9, 3.5292850412632427`*^9}, {3.529285215443486*^9, 
   3.529285215443486*^9}, {3.5295115356999426`*^9, 3.5295115433443794`*^9}, {
   3.529521412127842*^9, 3.529521414647986*^9}, {3.529529429975619*^9, 
   3.529529432955224*^9}, 3.5340074894011116`*^9, 3.5415537711400824`*^9, {
   3.5415538454742126`*^9, 3.54155384951462*^9}, {3.5417297197063265`*^9, 
   3.5417297252443366`*^9}, {3.546297494083555*^9, 3.5462974982435613`*^9}, {
   3.5462989134855423`*^9, 3.5462989153655453`*^9}, 3.548544146508506*^9, 
   3.5488738855784535`*^9, {3.548885292189272*^9, 3.5488853011492844`*^9}, {
   3.5488862802206554`*^9, 3.5488862887906675`*^9}, {3.5488873344221315`*^9, 
   3.5488873405921392`*^9}, {3.548887765702735*^9, 3.548887777862752*^9}, {
   3.5494211382132635`*^9, 3.549421138353264*^9}, {3.5532230040978823`*^9, 
   3.5532230095731955`*^9}, 3.5589035854423523`*^9, 3.558904571603733*^9, {
   3.5729232863509145`*^9, 3.5729232864913144`*^9}, {3.574364442189604*^9, 
   3.574364468839641*^9}, 3.57487965984332*^9, {3.5748797599018955`*^9, 
   3.574879760588297*^9}, {3.57488723261541*^9, 3.5748872327854104`*^9}, 
   3.574887727776103*^9, {3.5749614948631783`*^9, 3.5749614988631835`*^9}, 
   3.574964614077545*^9, {3.7210957216461277`*^9, 3.7210957361179557`*^9}, {
   3.721095985459217*^9, 3.7210959857452335`*^9}, {3.7210977863432217`*^9, 
   3.7210977909674864`*^9}},
 FontSize->12,
 FontWeight->"Bold"]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1908, 946},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{1, 32000},
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], " ", "|", " ", 
      StyleBox[
       ValueBox["FileName"], "Header"]}], "Header", 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
   Cell[
    TextData[{
     "Rules", " ", "for", " ", "integrands", " ", "involving", " ", "Bessel", 
      " ", "functions"}], "Header", 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, 
   Cell[
    TextData[
     CounterBox["Page", CounterFunction :> Identity]], "Header", 
    CellMargins -> {{Inherited, 0}, {Inherited, Inherited}}]}},
PageFooters->{{None, None, None}, {None, None, None}},
PageHeaderLines->{False, False},
PageFooterLines->{False, False},
PrintingOptions->{"FacingPages"->False,
"FirstPageFace"->Right,
"FirstPageFooter"->False,
"FirstPageHeader"->False,
"Magnification"->1.,
"PaperOrientation"->"Landscape",
"PaperSize"->{774, 597},
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 41.976}, {28.8, 28.8}}},
Magnification->1.399999976158142,
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2709, 41, 42, "Subsubtitle"],
Cell[CellGroupData[{
Cell[3279, 65, 3202, 51, 53, "Subsubtitle"],
Cell[CellGroupData[{
Cell[6506, 120, 3295, 53, 74, "Subsubtitle"],
Cell[CellGroupData[{
Cell[9826, 177, 3762, 66, 74, "Subsubtitle"],
Cell[CellGroupData[{
Cell[13613, 247, 4673, 72, 74, "Subsubtitle"],
Cell[18289, 321, 806, 11, 93, "Subsubsection"],
Cell[19098, 334, 1689, 34, 159, "Subsubtitle"],
Cell[20790, 370, 795, 11, 93, "Subsubsection"],
Cell[21588, 383, 984, 26, 282, "Code"],
Cell[22575, 411, 113, 2, 93, "Subsubsection"]
}, Closed]],
Cell[CellGroupData[{
Cell[22725, 418, 5012, 83, 74, "Subsubtitle"],
Cell[27740, 503, 1552, 37, 130, "Subsubsection"],
Cell[29295, 542, 961, 19, 99, "Subsubsection"],
Cell[30259, 563, 1966, 44, 159, "Subsubtitle"],
Cell[32228, 609, 795, 11, 93, "Subsubsection"],
Cell[33026, 622, 1432, 43, 282, "Code"],
Cell[34461, 667, 113, 2, 93, "Subsubsection"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34623, 675, 5079, 82, 74, "Subsubtitle"],
Cell[39705, 759, 977, 15, 48, "Subsubsection"],
Cell[40685, 776, 1465, 33, 36, "Subsubsection"],
Cell[42153, 811, 1826, 42, 36, "Subsubsection"],
Cell[43982, 855, 1016, 18, 36, "Subsubsection"],
Cell[45001, 875, 1882, 39, 74, "Subsubtitle"],
Cell[46886, 916, 795, 11, 48, "Subsubsection"],
Cell[47684, 929, 1414, 37, 145, "Code"],
Cell[49101, 968, 113, 2, 48, "Subsubsection"]
}, Closed]],
Cell[CellGroupData[{
Cell[49251, 975, 4525, 70, 74, "Subsubtitle"],
Cell[53779, 1047, 732, 10, 93, "Subsubsection"],
Cell[54514, 1059, 2318, 55, 221, "Subsubtitle"],
Cell[56835, 1116, 795, 11, 93, "Subsubsection"],
Cell[57633, 1129, 1679, 50, 282, "Code"],
Cell[59315, 1181, 113, 2, 93, "Subsubsection"]
}, Closed]]
}, Closed]],
Cell[59455, 1187, 3480, 57, 74, "Subsubtitle"],
Cell[62938, 1246, 3568, 59, 74, "Subsubtitle"]
}, Closed]],
Cell[66521, 1308, 3280, 52, 53, "Subsubtitle"],
Cell[69804, 1362, 3334, 53, 53, "Subsubtitle"]
}
]
*)

(* End of internal cache information *)
